
ALTER TABLE `shops`
ADD `registration_approval` TINYINT(1) NOT NULL DEFAULT 0 AFTER `package_invalid_at`;

UPDATE `shops`
SET `registration_approval` = 1
WHERE `verification_status` = 1;

INSERT INTO `permissions` (`id`, `name`, `section`, `guard_name`, `created_at`, `updated_at`) 
VALUES
(NULL, 'view_pending_seller', 'seller', 'web', current_timestamp(), current_timestamp()),
(NULL, 'mark_seller_suspected', 'seller', 'web', current_timestamp(), current_timestamp())
;

INSERT INTO `email_templates` (`id`, `receiver`, `identifier`, `email_type`, `subject`, `default_text`, `status`, `is_status_changeable`, `is_dafault_text_editable`, `addon`, `created_at`, `updated_at`) 
VALUES 
(NULL, 'seller', 'seller_shop_approval_email', 'Seller Shop Approval', 'Congratulations! Your Shop [[seller_shop_name]] Has Been Approved', '<span id="docs-internal-guid-7441a6d7-7fff-62b9-67a0-909d5d4ae5dd"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-weight:="" 700;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"=""><b>Dear [[seller_name]],</b></span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">Congratulations! Your shop has been approved and is now part of the <span style="font-size: 14.6667px;">[[store_name]]</span> seller network.</span><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">You can now log in, manage your store, and start listing your products.</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">Here are your account details:</span></p><ul style="margin-bottom: 0px; padding-inline-start: 48px;"><li dir="ltr" style="list-style-type: disc; font-size: 11pt; font-family: Arial, sans-serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space: pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-weight:="" 700;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">Name:</span><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"=""> </span><span style="font-family: " roboto="" slab",="" serif;="" font-size:="" 14.6667px;="" text-wrap:="" wrap;="" background-color:="" transparent;"="">[[seller_name]]</span></p></li><li dir="ltr" style="list-style-type: disc; font-size: 11pt; font-family: Arial, sans-serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space: pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;" role="presentation"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-weight:="" 700;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">Email:</span><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"=""> </span><span style="font-family: " roboto="" slab",="" serif;="" font-size:="" 14.6667px;="" text-wrap:="" wrap;="" background-color:="" transparent;"="">[[seller_email]]</span></p></li><li dir="ltr" style="list-style-type: disc; font-family: Arial, sans-serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space: pre;" aria-level="1"><p dir="ltr" style="line-height: 1.38; margin-top: 0pt; margin-bottom: 0pt;" role="presentation"><span style="font-size: 11pt;" roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">Shop Name</span><span style="font-size: 11pt; font-weight: 700; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">: </span><span style="font-size: 14.6667px; background-color: transparent;">[[seller_shop_name]]</span></p></li><li dir="ltr" style="list-style-type: disc; font-family: Arial, sans-serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space: pre;" aria-level="1"><p dir="ltr" style="line-height: 1.38; margin-top: 0pt; margin-bottom: 0pt;" role="presentation"><span style="font-size: 11pt;" roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">Address</span><span style="font-size: 11pt; font-weight: 700; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">: </span><span style="font-size: 14.6667px; background-color: transparent;">[[seller_shop_address]]</span></p></li><li dir="ltr" style="list-style-type: disc; font-family: Arial, sans-serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space: pre;" aria-level="1"><p dir="ltr" style="line-height: 1.38; margin-top: 0pt; margin-bottom: 12pt;" role="presentation"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-weight:="" 700;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"="">Registration Date:</span><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" text-wrap:="" wrap;"=""> </span><span style="font-size: 14.6667px; background-color: transparent;">[[date]]</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">To access your seller account, please log in </span><a href="[[login_url]]" target="_blank">here</a><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">.</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">If you need any assistance, our seller support team is available to help you with any questions or issues. Contact us at <span style="font-family: Roboto, sans-serif; font-size: 14.6667px;">[[admin_email]]</span>.</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">We are excited to see your products in our marketplace and look forward to your success!</span></p><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"="">Best regards,</span></p><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;"><span style="font-size: 11pt; font-family: " roboto="" slab",="" serif;="" background-color:="" transparent;="" font-variant-numeric:="" normal;="" font-variant-east-asian:="" font-variant-alternates:="" font-variant-position:="" vertical-align:="" baseline;="" white-space-collapse:="" preserve;"=""><b>The <span style="font-size: 14.6667px;">[[store_name]]</span> Team</b></span></p></span>', 1, 1, 1, NULL, NOW(), NOW());

UPDATE `email_templates` SET `default_text` = '<span id=\"docs-internal-guid-7441a6d7-7fff-62b9-67a0-909d5d4ae5dd\"><p dir=\"ltr\" style=\"line-height:1.38;margin-top:12pt;margin-bottom:12pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-weight: 700; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">Dear [[seller_name]],</span></p><p dir=\"ltr\" style=\"line-height:1.38;margin-top:12pt;margin-bottom:12pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">Thank you for creating your shop on <span style=\"font-size: 14.6667px;\">[[store_name]]</span>! We are excited to have you as part of our seller network.</span></p><p dir=\"ltr\" style=\"line-height:1.38;margin-top:12pt;margin-bottom:12pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">Your shop is currently pending approval. Once approved, you will be able to log in, manage your store, and list your products. We will notify you as soon as your shop is approved.</span></p><p dir=\"ltr\" style=\"line-height:1.38;margin-top:12pt;margin-bottom:12pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">If you need any assistance, our seller support team is available to help you with any questions or issues. Contact us at <span style=\"font-family: Roboto, sans-serif; font-size: 14.6667px;\">[[admin_email]]</span>.</span></p><p dir=\"ltr\" style=\"line-height:1.38;margin-top:12pt;margin-bottom:12pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">Thank you for choosing to partner with us!</span></p><p dir=\"ltr\" style=\"line-height:1.38;margin-top:0pt;margin-bottom:0pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">Best regards,</span></p><p dir=\"ltr\" style=\"line-height:1.38;margin-top:0pt;margin-bottom:0pt;\"><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\">The <span style=\"font-size: 14.6667px;\">[[store_name]]</span> Team</span></p><div><span style=\"font-size: 11pt; font-family: &quot;Roboto Slab&quot;, serif; background-color: transparent; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; vertical-align: baseline; white-space-collapse: preserve;\"><br></span></div></span>' WHERE id = 5;

INSERT INTO `business_settings` (`id`, `type`, `value`, `lang`, `created_at`, `updated_at`) 
VALUES 
(NULL, 'whatsapp_order', 0, NULL, current_timestamp(), current_timestamp()),
(NULL, 'order_messege_template', 'Hello [[storeName]], 
I am interested in ordering "[[productTitle]]".

Kindly provide me the order process and payment details. 
[[productUrl]]', NULL, current_timestamp(), current_timestamp());

UPDATE `business_settings` SET `value` = '9.9.6' WHERE `business_settings`.`type` = 'current_version';

COMMIT;